@extends('layout.main') @section('content')
@if(session()->has('message'))
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <h3>{{trans('file.Account Statement')}}</h3>
        <strong>{{trans('file.Account')}}:</strong> {{$lims_account_data->name}} [{{$lims_account_data->account_no}}]
    </div>
    <div class="table-responsive mb-4">
        <table id="account-table" class="table table-hover">
            <thead>
                <tr>
                    <th>{{trans('file.no')}}</th>
                    <th>{{trans('file.date')}}</th>
                    <th>{{trans('file.reference')}}</th>
                    @if($data['type']==0 || $data['type']==2)
                        <th>{{trans('file.Credit')}}</th>
                    @endif
                    @if($data['type']==0 || $data['type']==1)
                        <th>{{trans('file.Debit')}}</th>
                    @endif
                    <th>{{trans('file.Balance')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($statement_list as $key=>$list)               
                    <tr>
                        <td>{{$key+1}}</td>
                        <td>{{date($general_setting->date_format, strtotime($list->created_at->toDateString()))}}</td>
                        <td>
                            @if($list->payment_setting_id!=NULL)
                                @if($list->sale_id!=NULL)
                                    <a href="{{route('sale.invoice',$list->sale_id)}}" >{{$list->payment_note}}</a>
                                @else
                                     {{$list->payment_note}}
                                @endif                               
                            @else
                                @if($list->sale_id!=NULL)
                                    <a href="{{route('sale.invoice',$list->sale_id)}}" >{{$list->paying_method}} - Payment</a>
                                @else
                                    {{$list->paying_method}} - Payment
                                @endif
                            @endif
                        </td>
                        @if($data['type']==0 || $data['type']==2)
                            <td>{{number_format((float)$list->credit, 3, '.', '')}}</td>
                        @endif
                        @if($data['type']==0 || $data['type']==1)
                            <td>{{number_format((float)$list->debit, 3, '.', '')}}</td>
                        @endif
                        <td>{{number_format((float)$list->balance, 3, '.', '')}}</td>
                    </tr>
                @endforeach                
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #account-statement-menu").addClass("active");

    var table = $('#account-table').DataTable( {
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
             "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': 0
            },
            
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("file.PDF")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            },
        ],
    } );

</script>
@endsection