@extends('layout.main') @section('content')
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>{{trans('file.Add Employee')}}</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => 'employees.store', 'method' => 'post', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{trans('file.Salutation')}} *</strong> </label>
                                    <input type="text" name="salutation" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.fullName')}} *</strong> </label>
                                    <input type="text" name="full_name" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.company')}} *</strong> </label>
                                    <input type="text" name="company" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.user_id')}} *</strong> </label>
                                    <input type="text" name="user_id" required class="form-control">
                                </div>
                                <div class="form-group mt-5">
                                    <label>{{trans('file.employment_details')}}</label>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.status')}} *</label>
                                    <select class="form-control selectpicker" name="status" required>
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.employment_type')}} *</label>
                                    <input type="email" name="employment_type"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.holiday_list')}} *</label>
                                    <input type="text" name="phone_number" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{trans('file.date_of_joining')}} *</strong> </label>
                                    <input type="date" name="date_of_joining" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.date_of_birth')}} *</strong> </label>
                                    <input type="date" name="date_of_joining" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.gender')}} *</strong> </label>
                                    <select name="gender" class="form-control" required>
                                        <option value="">Select Your Gender</option>
                                        <option value="m">Male</option>
                                        <option value="f">Female</option>
                                        <option value="o">Other</option>
                                    </select>
                                </div>

                                <div class="form-group mt-5" style="margin-top: 165px !important;">
                                    <label>{{trans('file.offer_date')}} *</strong> </label>
                                    <input type="date" name="offer_date" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.confirmation_date')}} *</strong> </label>
                                    <input type="date" name="confirmation_date" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.contract_end_date')}} *</strong> </label>
                                    <input type="date" name="contract_end_date" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.date_of_retirement')}} *</strong> </label>
                                    <input type="date" name="date_of_retirement" required class="form-control">
                                </div>

                            </div>
                        </div>

<!--Job Detail Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mt-5">
                                    <label>{{trans('file.job_profile')}}</label>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.job_branch')}} *</label>
                                    <input type="text" name="job_branch"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.job_department')}} *</label>
                                    <input type="text" name="job_department"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.job_designation')}} *</label>
                                    <input type="text" name="job_designation" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.company_email')}} *</label>
                                    <input type="email" name="company_email" required class="form-control">
                                    <span style="font-size:10px">{{trans('file.provided_email_company')}}</span>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.notice')}} *</label>
                                    <input type="text" name="notice" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mt-5" style="margin-top: 88px !important;">
                                    <span style="font-size: 15px">{{trans('file.salary_information')}}</span><br>
                                    <label>{{trans('file.salary_mode')}} *</strong> 
                                    </label>
                                    <input type="text" name="salary_mode" required class="form-control">
                                </div>
                            </div>
                        </div>
<!--Organization Profile Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mt-5">
                                    <label>{{trans('file.organization_profile')}}</label>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.reports_to')}} *</label>
                                    <input type="text" name="reports_to"  required class="form-control">
                                    <span style="font-size:10px">{{trans('file.default_leave_approver')}}</span>
                                </div>
                            </div>
                        </div>

<!-- Contact detail -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mt-5">
                                    <label>{{trans('file.contact_details')}}</label>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.prefered_contact_email')}} *</label>
                                    <input type="email" name="prefered_contact_email"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.prefered_email')}} *</label>
                                    <input type="email" name="prefered_email"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.cell_number')}} *</label>
                                    <input type="tel" name="cell_number"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.personal_email')}} *</label>
                                    <input type="email" name="personal_email"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <input type="checkbox" id="unsubscribed" name="unsubscribed" 
                                    value="unsubscribed">
                                    <label for="unsubscribed"> {{trans('file.unsubscribed')}}</label>
                                    <br>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.emergency_contact')}} *</label>
                                    <input type="tel" name="emergency_contact"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.relation')}} *</label>
                                    <input type="text" name="relation"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.emergency_phone')}} *</label>
                                    <input type="tel" name="emergency_phone"  required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mt-5" style="margin-top: 88px !important;">
                                    <label>{{trans('file.permanent_address_is')}} *</strong> 
                                    </label>
                                    <input type="text" name="permanent_address_is" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.permanent_address')}} *</strong> 
                                    </label>
                                    <textarea rows="7" style="resize: none;" name="permanent_address" required class="form-control"></textarea>
                                </div>
                                <div class="form-grou">
                                    <label>{{trans('file.current_address_is')}} *</strong> 
                                    </label>
                                    <input type="text" name="current_address_is" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.current_address')}} *</strong> 
                                    </label>
                                    <textarea rows="7" style="resize: none;" name="current_address" required class="form-control"></textarea>
                                </div>
                            </div>
                        </div>
<!-- Bio detail -->                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mt-5">
                                    <label>{{trans('file.bio')}}</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <textarea name="summernote" id="summernote_1"></textarea>
                                     <span style="font-size:10px">{{trans('file.short_bio_message')}}</span>
                                </div>
                            </div>
                        </div>
<!-- Personal detail -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mt-5">
                                    <label>{{trans('file.personal_details')}}</label>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.passport_number')}} *</label>
                                    <input type="text" name="passport_number"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.date_of_issue')}} *</label>
                                    <input type="date" name="date_of_issue"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.valid_upto')}} *</label>
                                    <input type="date" name="valid_upto"  required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.place_of_issue')}} *</label>
                                    <input type="text" name="place_of_issue"  required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mt-5" style="margin-top: 88px !important;">
                                    <label>{{trans('file.marital_status')}} *</strong> 
                                    </label>
                                    <input type="text" name="marital_status" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.blood_group')}} *</strong> 
                                    </label>
                                    <input type="text" name="blood_group" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.family_background')}} *</strong> 
                                    </label>
                                    <textarea rows="4" style="resize: none;" name="family_background" required class="form-control"></textarea>
                                    <span style="font-size:10px">{{trans('file.family_background_note')}}</span>
                                </div>
                                <div class="form-group">
                                    <label>{{trans('file.health_details')}} *</strong> 
                                    </label>
                                    <textarea rows="4" style="resize: none;" name="health_details" required class="form-control"></textarea>
                                    <span style="font-size:10px">{{trans('file.health_note')}}</span>
                                </div>
                            </div>
                        </div>
                         <div class="col-md-12">
                                <div class="form-group mt-4">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                         </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#hrm").siblings('a').attr('aria-expanded','true');
    $("ul#hrm").addClass("show");
    $("ul#hrm #employee-menu").addClass("active");

    $('#warehouse').hide();
    $('#biller').hide();

    $('input[name="user"]').on('change', function() {
        if ($(this).is(':checked')) {
            $('#user-input').show(400);
            $('input[name="name"]').prop('required',true);
            $('input[name="password"]').prop('required',true);
            $('select[name="role_id"]').prop('required',true);
        }
        else{
            $('#user-input').hide(400);
            $('input[name="name"]').prop('required',false);
            $('input[name="password"]').prop('required',false);
            $('select[name="role_id"]').prop('required',false);
            $('select[name="warehouse_id"]').prop('required',false);
            $('select[name="biller_id"]').prop('required',false);
        }
    });

    $('select[name="role_id"]').on('change', function() {
        if($(this).val() > 2){
            $('#warehouse').show(400);
            $('#biller').show(400);
            $('select[name="warehouse_id"]').prop('required',true);
            $('select[name="biller_id"]').prop('required',true);
        }
        else{
            $('#warehouse').hide(400);
            $('#biller').hide(400);
            $('select[name="warehouse_id"]').prop('required',false);
            $('select[name="biller_id"]').prop('required',false);
        }
    });
</script>

<!-- Summerynotes -->
<script>
        $(document).ready(function() {
            $('#summernote_1').summernote({
                height: 300,
            });
        });
</script>
@endsection