<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Designation;
use Illuminate\Validation\Rule;

class DesignationController extends Controller
{
    
    public function index()
    {
        $lims_designation_all = Designation::where('is_active', true)->get();
        return view('designation.index', compact('lims_designation_all'));
    }
    
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => [
                'max:255',
                    Rule::unique('designation')->where(function ($query) {
                    return $query->where('is_active', 1);
                }),
            ],
        ]);

        $data = $request->all();
        $data['is_active'] = true;
        Designation::create($data);
        return redirect('designation')->with('message', 'Designation created successfully');
    }
    
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name' => [
                'max:255',
                Rule::unique('designations')->ignore($request->designation_id)->where(function ($query) {
                    return $query->where('is_active', 1);
                }),
            ],
        ]);
        
        $data = $request->all();
        $lims_designation_data = Designation::find($data['designation_id']);
        $lims_designation_data->update($data);
        return redirect('designations')->with('message', 'Designation updated successfully');
    }

    public function deleteBySelection(Request $request)
    {
        $designation_id = $request['designationIdArray'];
        foreach ($designation_id as $id) {
            $lims_designation_data = Designation::find($id);
            $lims_designation_data->is_active = false;
            $lims_designation_data->save();
        }
        return 'designation deleted successfully!';
    }

    public function destroy($id)
    {
        $lims_designation_data = Designation::find($id);
        $lims_designation_data->is_active = false;
        $lims_designation_data->save();
        return redirect('designations')->with('message', 'Designation deleted successfully');
    }
}
